

package GttMatch;

import java.awt.*;
import java.net.URL;

public class ImagePanel extends Panel
{

    public ImagePanel()
    {
        super.setLayout(null);
        image = getToolkit().getImage(getClass().getResource("gtt_logo_app.gif").getFile());
        if(image != null)
        {
            MediaTracker mediatracker = new MediaTracker(this);
            try
            {
                mediatracker.addImage(image, 0);
                mediatracker.waitForAll();
            }
            catch(InterruptedException interruptedexception) { }
            repaint();
        }
    }

    public void paint(Graphics g)
    {
        Dimension dimension = getSize();
        if(image != null)
            g.drawImage(image, 0, 0, dimension.width, dimension.height, this);
        else
            g.clearRect(0, 0, dimension.width, dimension.height);
        super.paint(g);
    }

    private transient Image image;
}
